//=============================================================================
// Button1.
//=============================================================================
class CaptureAmmoButton extends MSCCraftingDeco;

#exec TEXTURE IMPORT NAME="CaptureAmmoButton" FILE="Textures\AmmoCaptureButton.pcx" GROUP=Skins

var() class<Ammo> CaptureAmmo;

var Actor LastFrobber;
var float FrobTimer;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;
var rotator rpcRotation;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation, rpcRotation;
}

function Frob(Actor F, Inventory FW)
{
 if ( WeaponCraftBox(DeusExPlayer(F).inHand) == None)
 {
  Pawn(F).ClientMessage("|p4Please equip your weapon parts box first.");
  return;
 }
 
 if (DeusExPlayer(F) != None && WeaponCraftBox(DeusExPlayer(F).inHand) != None && FrobTimer > 0 && F == LastFrobber)
 {
  PlaySound(sound'Beep1', SLOT_Misc, 255, False, 128);
  WeaponCraftBox(DeusExPlayer(F).inHand).SetAmmo(CaptureAmmo);
  return;
 }

 LastFrobber = F;
 FrobTimer = 5;
 Pawn(F).ClientMessage("|p4Press this button again to get |p3"$Right(CaptureAmmo, Len(CaptureAmmo) - 4 - InStr(CaptureAmmo, "Ammo"))$" Ammo |p4for your weapon.");
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{	
	if (FrobTimer > 0)
	{
	 FrobTimer -= DeltaTime;
	}
					  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
			{
				rpcLocation = Location;
                                rpcRotation = Rotation;
			}
			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				SetRotation( rpcRotation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}
defaultproperties
{
     bBlockActors=True
     bBlockPlayers=True
     bInvincible=True
     ItemName="Ammo Capture Button"
     bPushable=False
     Physics=PHYS_None
     Skin=Texture'CaptureAmmoButton'
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     Mass=5.000000
     Buoyancy=2.000000
}

